package com.it;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

import org.xhtmlrenderer.pdf.ITextRenderer;

import com.lowagie.text.pdf.BaseFont;


public class App {
	public void createPdf() throws Exception {
		// step 1
		String inputFile = "Real.html";
		String url = new File(inputFile).toURI().toURL().toString();
		String outputFile = "Real.pdf";
		System.out.println(url);
		// step 2
		OutputStream os = new FileOutputStream(outputFile);
		ITextRenderer renderer = new ITextRenderer();
		renderer.setDocument(url);		

		// step 3 解决中文支持, linux 下可以复制字体到 linux 字体目录下。
		String osName = System.getProperty("os.name").toLowerCase();	
		org.xhtmlrenderer.pdf.ITextFontResolver fontResolver = renderer.getFontResolver();
		if (osName.startsWith("win")) {
			fontResolver.addFont("c:/Windows/Fonts/simsun.ttc", BaseFont.IDENTITY_H,BaseFont.NOT_EMBEDDED);		
		} else {
			fontResolver.addFont("linux 下的路径", BaseFont.IDENTITY_H,BaseFont.NOT_EMBEDDED);	
		}

		renderer.layout();
		renderer.createPDF(os);
		os.close();
		
		System.out.println("create pdf done!!");
	}


	public static void main(String[] args) throws Exception {
		App app = new App();
		app.createPdf();
	}

}