var structuredProduct = new Component("positionDetail/structuredProduct");
app.registerComponent(structuredProduct);
structuredProduct.on("load", function(){
	var self = this;
	url = "asset/position/" + app.selectBpKey + "?asOfDate=" + app.selectDateValue + "&assetClass1=Structured%20Products";
	return structuredProduct.render(
			"template/structuredProduct.html", 
    		"mainContent", 
    		url
	).done(function(template, data) {
		self.buttonEvent();

		var count = 0;
		$.each(data.data.result.assetPosition, function(portfolioNo, value){
			//set the netAssetValue
			getNetAssetValue(app.selectBpKey, portfolioNo, count);
			count++;
		});
		
		self.switchNotesLang();
		
		//set the height of tableScrollDiv adjust the window's height
		setPositionDetailPageScrollHeight();
		
		trackAction("StructuredProductsPosition - View");
		
    }); 
	
});

structuredProduct.switchNotesLang = function(){
	//set Notes
	var notes = lang.messages.notes_structured;
	$("#notes").html(notes.replaceAll("\n", "<br>"));
	
};

structuredProduct.buttonEvent = function() {
	var self = this;
	$("#structuredProductsSelectId").val(app.selectDateValue);
	$("#structuredProductsSelectId").die();
	$("#structuredProductsSelectId").live("change",function(){
//		app.selectDateValue = $("option:selected", this).html();
//		structuredProduct.trigger("load");
		app.trigger("changeAsOfDate", self.id, $("option:selected", this).html());
		trackAction("StructuredProductsPosition - ChangeDate");
	});
};