/* moneyAccount component, write logic of moneyAccount module in this class */
var moneyAccount = new Component("positionDetail/moneyAccount");
app.registerComponent(moneyAccount);
moneyAccount.on( "load", function(){
	var self = this;
	url = "cash/position/" + app.selectBpKey + "?asOfDate=" + app.selectDateValue;
	return moneyAccount.render(
			"template/positionDetail_moneyAccount.html", 
    		"mainContent", 
    		url).done(function(template, data) {
				self.buttonEvent();
//				console.log(data);
				var count = 0;
				$.each(data.data.result.cashPosition, function(portfolioNo, value){
					//set the netAssetValue
					getNetAssetValue(app.selectBpKey, portfolioNo, count);
					count++;
				});
				
				//set the height of tableScrollDiv adjust the window's height
				setPositionDetailPageScrollHeight();
				
				self.switchNotesLang = function(){
					//set notes
					$.each(data.data.result.portfolio,function(portfolioNo, value){
						if(value.hasMetalCcy===true){						
							var notes = lang.messages.notes_moneny_metal;
							$("#notes").html(notes.replaceAll("\n", "<br>"));
						}
					});	
				};
				self.switchNotesLang();
				trackAction("MoneyAccountPosition - View");
    		}); 
	
});

moneyAccount.buttonEvent = function() {
	var self = this;
	$("#moneyAccountSelectId").val(app.selectDateValue);
	$("#moneyAccountSelectId").die();
	$("#moneyAccountSelectId").live("change",function(){
//		app.selectDateValue = $("option:selected", this).html();
//		moneyAccount.trigger("load");
		app.trigger("changeAsOfDate", self.id, $("option:selected", this).html());
		trackAction("MoneyAccountPosition - ChangeDate");
	});
};
