/* funds component, write logic of funds module in this class */
var derivatives = new Component("positionDetail/derivatives");
app.registerComponent(derivatives);
derivatives.on( "load", function(){
	var self = this;
	url = "asset/position/" + app.selectBpKey + "?asOfDate=" + app.selectDateValue + "&assetClass1=Derivatives";
	return derivatives.render(
			"template/positionDetail_derivatives.html", 
    		"mainContent", 
    		url).done(function(template, data) {
				self.buttonEvent();

				var count = 0;
				$.each(data.data.result.assetPosition, function(portfolioNo, value){
					//set the netAssetValue
					getNetAssetValue(app.selectBpKey, portfolioNo, count);
					count++;
				});
				
				self.switchNotesLang = function(){
					//set notes
					var notes = lang.messages.notes_derivates_notes + "<br>";
					if(data.data.result.hasEquities == true) {
						notes += lang.messages.notes_derivates_equ + "<br>";
					}
					if(data.data.result.hasFixedIncome == true) {
						notes += lang.messages.notes_derivates_fix + "<br>";
					}
					if(data.data.result.hasFx == true) {
						notes += lang.messages.notes_derivates_fx + "<br>";
					}
					if(data.data.result.hasCommodities == true) {
						notes += lang.messages.notes_derivates_com + "<br>";
					}
					notes += lang.messages.notes_derivates;
					notes = notes.replaceAll("\n", "<br>").replaceAll("\t", "<span style='margin-left: 20px;'></span>");
					$("#notes").html(notes);
				};
				
				self.switchNotesLang();
				//set the height of tableScrollDiv adjust the window's height
				setPositionDetailPageScrollHeight();
				
				//set the color of table base on odd or even
//				$.each($(".oddEvenColor"), function() {
//					var id = $(this).attr("id");
//					console.log("id = " + id);
//					if(id % 2 != 0) {
//						$(this).css({"border" : "5px solid", "color" : "#C1C182"});
//					}
//				});
				
				trackAction("DerivativesPosition - View");
				
    		}); 
	
});

derivatives.buttonEvent = function() {
	$("#derivativesSelectId").val(app.selectDateValue);
	$("#derivativesSelectId").die();
	$("#derivativesSelectId").live("change",function(){
//		app.selectDateValue = $("option:selected", this).html();
//		derivatives.trigger("load");
		app.trigger("changeAsOfDate", "positionDetail/derivatives", $("option:selected", this).html());
		trackAction("DerivativesPosition - ChangeDate");
	});
};
