var portfolioList = $.extend( new Component("portfolioList"), {
		portfolioNumberInput : null,
		bpKeyInput : null,
		portfolioNumberInputValue : "",
		bpKeyInputValue : "",
		cachePortfolioNumberStr : ""
	}
);

app.registerComponent(portfolioList);

portfolioList.changePortfolioNumber = function(bpNumber){
    if(app.user.portfolioList){
        var shortbpNumberList = app.user.portfolioList[bpNumber];
        $("#combobox3").empty();
        this.portfolioNumberInput.val("");
        if(shortbpNumberList){
            var buffer = new StringBuffer();
            for(var i = 0; i < shortbpNumberList.length; i++){
                buffer.append("<option value='")
                .append(shortbpNumberList[i])
                .append("'>").append(shortbpNumberList[i])
                .append("</option>");
            }
            $("#combobox3").append(buffer.toString());
        }
    }
};

portfolioList.list = function(currentPage){
    trackAction("PorfolioList - ChangePage");
    var proprtie = "";
    var direction = "";
    if(this.proprtie){
        proprtie = this.proprtie;
    }
    if(this.direction){
        direction = this.direction;
    }
    if(this.portfolioNumberInput && this.portfolioNumberInput.length == 1){
        this.portfolioNumberInputValue = this.portfolioNumberInput.val();
    }
    if(this.bpKeyInput && this.bpKeyInput.length == 1){
        this.bpKeyInputValue = this.bpKeyInput.val();
    }
    var url = new StringBuffer();
    url.append("portfolio?asOfDate=").append(app.selectDateValue);
    if(currentPage){
        url.append("&page=").append(currentPage);
    }
    if(this.portfolioNumberInputValue){
        url.append("&portfolioNumber=").append(this.portfolioNumberInputValue);
    }
    /*if(this.bpKeyInputValue){
        url.append("&bpKey=").append(this.bpKeyInputValue);
    }*/
    if($.isArray(app.user.bpKey)) {
        this.bpKeyInputValue = app.selectBpKey;
    }else {
        this.bpKeyInputValue = app.user.bpKey;
    }
    if(this.bpKeyInputValue){
        url.append("&bpKey=").append(this.bpKeyInputValue);
    }
    
    if(proprtie){
        url.append("&proprtie=").append(proprtie);
    }
    if(direction){
        url.append("&direction=").append(direction);
    }
	var self = this;
	return  this.render("template/portfolio_list.html", "mainContent", url.toString() )
            .done( function (template, data){
                $("#portfolioListSelectAsofdate").val(app.selectDateValue);
            	self.listCallBack(template, data);  
            });
};

portfolioList.listCallBack = function(template, data){
    if(this.sortA){
        var iconId = $(this.sortA).attr("id");
        var icon = $("#" + iconId);
        if(icon.hasClass("sortDownIcon")){
            icon.removeClass("sortDownIcon").addClass("sortDownIcon_click");
        }else if(icon.hasClass("sortUpIcon")){
            icon.removeClass("sortUpIcon").addClass("sortUpIcon_click");
        }
    }
    var self = this;
    $( "#combobox2" ).combobox({
        "select": function(item, data){
        	self.changePortfolioNumber(data.value);
        },
        "change": function(item, v){
            if(v.checked){
            	portfolioList.changePortfolioNumber(this.value);
            }
            if(this.value === "" || this.value === null || this.value === undefined ){
                $("#combobox3").empty().append(self.cachePortfolioNumberStr);
            }
        },
        "finish_create":function(item, data){
            portfolioList.bpKeyInput = data.input;
        }
    });
    $( "#combobox3" ).combobox({
        "finish_create":function(item, data){
        	portfolioList.portfolioNumberInput = data.input;
        },
        "select": function(item, data){
            self.changePortfolioNumber(data.value);
        }
    });

    var html = genPaginationFooter(data.pagination, "portfolioList.list");
    $("#portfolioPagination1").empty().append(html);
    $("#portfolioPagination2").empty().append(html);
    $("#portfolioComboboxDiv").on("resolve" , function(){
        var bpkeys = app.user.bpKey;
        if(bpkeys != null && bpkeys.length > 0){
            var buffer = new StringBuffer();
            for(var i = 0; i < bpkeys.length; i++){
                buffer.append("<option value='").append(bpkeys[i]).append("'>").append(bpkeys[i]).append("</option>");
            }
            $("#combobox2").append(buffer.toString());
        }
        var buffer = new StringBuffer();
        $.each(app.user.portfolioList, function(bpkey, shortArray){
            if(shortArray){
                
                $.each(shortArray, function(i , portfolioNumber){
                    buffer.append("<option value='").append(portfolioNumber).append("'>").append(portfolioNumber).append("</option>");
                });
            }
        });
        $("#combobox3").append(buffer.toString());
        self.cachePortfolioNumberStr = buffer.toString();//cache
    });
    app.user.role.checkHtmlElements();
    
    this.portfolioNumberInput.val(this.portfolioNumberInputValue);
    this.bpKeyInput.val(this.bpKeyInputValue);
};

portfolioList.portfolioSearchButton2Click = function(){
    this.list(1);
};

portfolioList.sort = function(proprtie, direction, a){
    trackAction("PorfolioList - Sort");
    this.proprtie = proprtie;
    this.direction = direction;
    this.sortA = a;
    this.list(1, proprtie, direction);
};

portfolioList.on( "load", function(){
    this.portfolioNumberInputValue = "";
    this.bpKeyInputValue = "";
    if(this.portfolioNumberInput){
        this.portfolioNumberInput.val("");
        this.bpKeyInput.val("");
    }
    this.proprtie = "";
    this.direction = "";
    this.sortA = "";
    return this.list(1).done();
});

$("#portfolioListSelectAsofdate").die().live("change",function(){
    trackAction("PorfolioList - ChangeDate");
    app.trigger("changeAsOfDate", "portfolioList", $("#portfolioListSelectAsofdate").val()).done(function(){
    	if($("#clientHome").is(":visible")&& $("#helpManualAsHome").is(":visible")){
			 $("#helpManualAsHome").hide().trigger("reject");
		}
		if($("#helpManualAsHome").is(":visible") && $("#helpManual").is(":visible") ){
			//$("#helpManual").hide().trigger("reject");
			if (self.user.role.checkRole("hasAnyRole('WMD_Reports')")){
				$("#helpManualAsHome").hide().trigger("reject");
			} else {
				$("#helpManual").hide().trigger("reject");
			}
		}
    	 //portfolioList.list(1);
    });
});