var lang = {
    currentLang : "",
    messages : null,
    EN: "en",
    ZH_CN: "zh_CN",
    ZH_TW: "zh_TW",
    langVars : {
            zh_CN : { className:"zhcLang", text:"Chinese", divId:"zhcLangId"},
            zh_TW : { className:"zhtLang", text:"ChineseTW", divId:"zhtLangId"},
            en : { className:"engLang", text:"English", divId:"engLangId"}
    },
    /**
     * This function includes cache function, 
     * so http request will only be triggered on first request a lang's message
     * @returns a deferred object
     */
    getLangMessages : function(lang){
    	var self = this;
    	app.doAjaxRequest = true;
        var url = app.EPRESTAPI_CONTEXT_ROOT + "internation/language/" + lang;
        var dtd = ajaxCall( {
			url:url, 
			dataType : "json"
		}, true).done(function(){
//			self.messages = arguments[0];
			self.messages = arguments[0].data.data;
			app.trigger("langChanged");
			app.doAjaxRequest = false;
		});
        return dtd;
    },
    updateLangMenu: function(lang){
        currentLang = lang;
        
        var langVar = this.langVars[lang];
        $(".selectedLanguage").html("<span class='" + langVar.className + " Lang'></span><span style='float:left;'>" 	+ langVar.text) + "</span>";
        $("#zhcLangId, #zhtLangId, #engLangId").each ( function(){
			var $element = $(this);
            if (this.id === langVar.divId){
                $element.hide();
            }
            else{
                $element.show();
            }
        });
        //IE7 bug,Set LanguageView's width
        if($.browser.msie) {
	        if("en" == lang) {
	        	$("#languageViewId").css("width", "73px");
	        } else if("zh_CN" == lang) {
	        	$("#languageViewId").css("width", "75px");
	        } else if("zh_TW" == lang) {
	        	$("#languageViewId").css("width", "92px");
	        }
        }
    },
    setLang : function(lang, targetDivId){
        this.currentLang = lang;
        setCookie( app.getLangCookieName(), this.currentLang , 365, app.COOKIES_DOMAIN);
        
        if(app.doAjaxRequest == false) {
			this.updateLangMenu(lang);
			this.updateUIMessages(targetDivId).done( function(){
				app.reLoadComponents();
			});
        }
    },
    updateUIMessages : function(targetDivId){
    	var lang = this.currentLang,
    		self = this;
    	var parent = targetDivId ? $("#" + targetDivId) : $(document);
    	var dtd = this.getLangMessages(lang)
    	.done( function(){
    	    self.setHomePageMessage(lang);
     		parent.find("[msgid]").each(function() {
     			var messages = self.messages;
    			var thisNode = $(this);
    			//console.log("msgId = " + thisNode.attr("msgid"));
    			var message=messages[thisNode.attr("msgid")];
    			if(message && thisNode.attr('errorMsgParam')){
    				message=message.replace('{0}',thisNode.attr('errorMsgParam'));
    			}
    			if(thisNode.attr("msgid").indexOf("notes_") != -1) {
    				var msgidStr = message;
    				var notes = msgidStr && msgidStr.replaceAll("\n|\\\\n", "<br>").replaceAll("\t|\\\\t", "<span style='margin-left: 20px;'></span>");
    				thisNode.html(notes || thisNode.html());
    			} else {
    				if(message)
    					message=message.replaceAll("\n|\\\\n", "<br>").replaceAll("\t|\\\\t", "<span style='margin-left: 20px;'></span>");
    				thisNode.html(message || thisNode.html());
    			}
    		});
     		app.mainComponent && app.mainComponent.switchNotesLang && app.mainComponent.switchNotesLang();
        });
        return dtd;
    },
    updateUIMessagesInHtml : function(html){
    	var lang = this.currentLang,
    		self = this;
    	var parent =  $(html);
    	var f=function(){
	    	var dtd = self.getLangMessages(lang)
	    	.done( function(){
	     		parent.find("[msgid]").each(function() {
	     			var messages = self.messages;
	    			var thisNode = $(this);
	    			//console.log("msgId = " + thisNode.attr("msgid"));
	    			var message=messages[thisNode.attr("msgid")];
	    			if(message && thisNode.attr('errorMsgParam')){
	    				message=message.replace('{0}',thisNode.attr('errorMsgParam'));
	    			}
	    			if(thisNode.attr("msgid").indexOf("notes_") != -1) {
	    				var msgidStr = message;
	    				var notes = msgidStr && msgidStr.replaceAll("\n|\\\\n", "<br>").replaceAll("\t|\\\\t", "<span style='margin-left: 20px;'></span>");
	    				thisNode.html(notes || thisNode.html());
	    			} else {
	    				thisNode.html(message || thisNode.html());
	    			}
	    		});
	     		app.mainComponent && app.mainComponent.switchNotesLang && app.mainComponent.switchNotesLang();
	        });
	    	return dtd;
    	};
    	f();
    	return parent;
    },
    updateUIMessageWithOutGetData : function(targetDivId) {
    	//return this.updateUIMessages(targetDivId);
    	var parent = targetDivId ? $("#" + targetDivId) : $(document);
    	var messages = this.messages;
    	parent.find("[msgid]").each(function() {
			var thisNode = $(this);
			thisNode.html(messages[thisNode.attr("msgid")] || thisNode.html());
		});
    },
    getMessage : function(messageId){
        if(messageId && this.messages[messageId]){
            var messageText = this.messages[messageId];
            messageText = messageText.replaceAll("\n","<br>");
            return messageText;
        }else{
            return "";
        }
        
    },
    renderMessage : function(messageId, divId){
        var messageText = this.getMessage(messageId);
        $("#" + divId).empty().append(messageText);
    },
    setHomePageMessage : function (lang){
        var isHomepage = $("#homepageFlag").val() == 1 ? true : false;
        var isNeededChange = false;
        if("zh_CN" == lang || "zh_TW" == lang){
            isNeededChange = true;
        }
        this.renderMessage("msgNomuraLeadingFinancial", "msgNomuraLeadingFinancial");
        if (isHomepage && isNeededChange){
            $("#msgNomuraLeadingFinancial").addClass("bannerImage_text_font");
        }else{
            $("#msgNomuraLeadingFinancial").removeClass("bannerImage_text_font");
        }
    }
//    reLoadComponents : function(){
//    	app.trigger("load", "quickAccessLink");
//    	//find mainContent's chidren div
//    	var mainContentComponentDiv = $("#mainContent").find("div.mainComponent").attr("id");
//    	if(mainContentComponentDiv != undefined) {
//    		//reload the mainContent div's content
//    		eval(mainContentComponentDiv).trigger("load");
//    	}
//    }
};