Date.prototype.getWeek = function(){
    var firstDayOfYear = new Date(this.getFullYear(),0,1);
    var millOfDay = 24*60*60*1000;
    return Math.ceil((((this - firstDayOfYear) / millOfDay) + firstDayOfYear.getDay()+1)/7);
};

/*
01 October 2013-10:20:20
01 November 2013-10:20:20
01 December 2013-10:20:20
08 October 2013-01:55 pm
*/

var monthMapping = {
    "January" : "01",
    "February" : "02",
    "March" : "03",
    "April" : "04",
    "May" : "05",
    "June" : "06",
    "July" : "07",
    "August" : "08",
    "September" : "09",
    "October" : "10",
    "November" : "11",
    "December" : "12"
};

function formatAmPm() {
    var dateTimeStr = arguments[0] ;   
    var dateStr = dateTimeStr.split("-");
    if (lang.currentLang == "zh_CN" || lang.currentLang == "zh_TW"){
        var s_year = lang.getMessage('yearCn') ;
        var s_month = lang.getMessage('monthCn') ;
        var s_day = lang.getMessage('dayCn') ;
        var dateArray = dateStr[0].split(" ") ;
        var s_time = dateStr[1].split(" ")[1] == "am" ? lang.getMessage('amCn') :lang.getMessage('pmCn') ;
        var ret =  dateArray[2] + s_year + monthMapping[dateArray[1]] + s_month + dateArray[0] + s_day + " " + s_time + dateStr[1].split(" ")[0] ; 
        if ( arguments.length > 1 ){
            /*admin feature ,so using en date*/
            ret = arguments[1] ? dateStr[0] : dateStr[1] ;
        }
        return ret ;
    }    
    else{
        if ( arguments.length > 1 ){
            return arguments[1] ? dateStr[0] : dateStr[1] ;            
        }
        else{
            return dateStr[0] + " " + dateStr[1] ;
        }
    }   
}

function formatDate(dateTime, pattern) {
	if(pattern == "" || pattern == null) {
		pattern = "/";
	}
    var date = new Date(dateTime);
    var year = date.getFullYear();
    var month = date.getMonth()+1;
    month = month <10 ? '0'+month : month;
    var day = date.getDate();
    day = day <10 ? '0'+day : day;
    return month + pattern + day + pattern + year;
}

function formatDateDDMMYYYY(dateTime) {
	var ymd = dateTime.split(" ")[0];
	var dateArray = ymd.split("-");
	return dateArray[2]+"."+dateArray[1]+"."+dateArray[0];
}
/**
 * 
 * @param dateTime YYYY-MM-DD hh:mm:ss
 */
function formatDateDDMMYY(dateTime){
	var ymd = dateTime.split(" ")[0];
	var dateArray = ymd.split("-");
	return dateArray[2]+"."+dateArray[1]+"."+dateArray[0].substring(2);
}

/**********************calculate date*****************************/
var MONTH = [
             {key:"Jan.",value:1},
             {key:"Feb.",value:2},
             {key:"Mar.",value:3},
             {key:"Apr.",value:4},
             {key:"May.",value:5},
             {key:"Jun.",value:6},
             {key:"Jul.",value:7},
             {key:"Aug.",value:8},
             {key:"Sept.",value:9},
             {key:"Oct.",value:10},
             {key:"Nov.",value:11},
             {key:"Dec.",value:12}                   
             ];
var DAYS = [31,28,31,30,31,30,31,31,30,31,30,31];

function getYears(){
    var years = [];
    var date = new Date();
    var year = date.getFullYear();
    var minYear = year - 10;    
    for(var currentYear=minYear;currentYear <= year;currentYear++){
        years.push(currentYear);
    }
    return years;
};

function fillinMonthOptions(id,currentMonth){
    $("#" + id).get(0).options.length = 0;
    for(var i= 0;i<MONTH.length; i++){
        if (MONTH[i].value == currentMonth){
            $("#" + id).append("<option value="+MONTH[i].value+" selected=\"selected\">"+MONTH[i].key+"</option>");
        }
        else{
            $("#" + id).append("<option value="+MONTH[i].value+">"+MONTH[i].key+"</option>");
        }
    }
};

function fillinAllMonthOptions(monthIds,currentMonth){
    //var monthIds = ["loginMonth_1","loginMonth_2","auditMonth_1","auditMonth_2"];
    for (var i=0;i<monthIds.length;i++){
        fillinMonthOptions(monthIds[i],currentMonth);
    };   
};

function fillinYearOptions(id,years,currentYear){
    $("#" + id).get(0).options.length = 0;
    for(var i= 0;i<years.length; i++){
        if (years[i] == currentYear){
            $("#" + id).append("<option value="+years[i]+" selected=\"selected\">"+years[i]+"</option>");
        }
        else{
            $("#" + id).append("<option value="+years[i]+">"+years[i]+"</option>");
        }
    }
};

function fillinAllYearOptions(yearIds,currentYear){
    //var yearIds = ["loginYear","auditYear"];
    years = getYears();
    for(var i= 0;i<yearIds.length; i++){
        fillinYearOptions(yearIds[i],years,currentYear);
    }
};

function isLeapYear(year){
    return (year % 4 === 0) && (year % 100 !==0) || (year % 400 === 0);
}

/*get days of a month*/
function getMonthDays(year,month){
    var monthDays = DAYS[month-1];
    if (isLeapYear(year) && month == 2){
        monthDays = 29;
    }
    return monthDays;
}

function fillinDay(id,monthDays){
    $("#" + id).get(0).options.length = 0;
    for(var i=1;i<=monthDays;i++){
        $("#" + id).append("<option value="+i+">"+i+"</option>");
    }
}

function fiilinDays(year,month,dayIds){
    var monthDays = getMonthDays(year,month);
    for(var i=0;i<dayIds.length;i++){
        fillinDay(dayIds[i],monthDays);
    }
}

function getWeeksOfYear(year){
    var firstDayOfYear = new Date(year,0,1);
    var days = firstDayOfYear.getDay() + (isLeapYear(year) ? 366 : 365);
    return Math.ceil(days/7);
}

function getCurrentWeekNo(){
    var currentDate = new Date();
    var firstDay = new Date(currentDate.getFullYear(),0,1);
    var dayms = 24 * 60 * 60 * 1000;
    var numday = ((currentDate - firstDay) / dayms );
    var weeks = Math.ceil((numday + firstDay.getDay() + 1) / 7);
    return weeks;
}

function getWeekRangeOfWeek(year,weekNo){
    var tmpDate = new Date("1/20/" + year);
    var numOfDaysPastSinceLastMonday = tmpDate.getDay()-1;
    tmpDate.setDate(tmpDate.getDate() - numOfDaysPastSinceLastMonday);
    var weekNoToday = tmpDate.getWeek();
    var weeksInFuture = weekNo - weekNoToday;
    tmpDate.setDate(tmpDate.getDate() + (7 * weeksInFuture) );
    var rangeFrom = tmpDate.getDate() + "/" +  MONTH[tmpDate.getMonth()].key;
    tmpDate.setDate(tmpDate.getDate() + 6);
    var rangeTo = tmpDate.getDate() + "/" + MONTH[tmpDate.getMonth()].key ;
    return weekNo + "_#_" + rangeFrom + "_#_" + rangeTo ;

}

function fillinWeek(weekId,year){
    $("#" + weekId).get(0).options.length = 0;
    var weeksOfYear = getWeeksOfYear(year);
    var weeks = [];
    for(var i=0;i<weeksOfYear;i++){
        weeks.push(getWeekRangeOfWeek(year,i+1));
    }
    for(var j=0;j<weeks.length;j++){
        var week = weeks[j].split("_#_");
        $("#" + weekId).append("<option value="+week[0]+">"+week[0] + "(" + week[1]+"-"+week[2]+")</option>");
    }
}

function fillinWeeks(year,weekIds){
    for (var i=0;i<weekIds.length;i++){
        fillinWeek(weekIds[i],year);
    }
}


