/* Component class */
function Component(id){
	//component id, e.g. "faq", "quickAccess"...
	this.id = id;
	//this.components = [];
	this.events = {};
};

/**
 * trigger event by eventName
 * */
Component.prototype.trigger = function(eventName){
	
	var handlers = this.events[eventName] || [];
	var args = Array.prototype.map.call(arguments, function (x) { return x; });
	args.shift();
	
	var self = this;
	var dtd = $.Deferred();
	var dtdArry = [];
	handlers.forEach( function(e){
		dtdArry.push(e.apply(self, args));
	});
	$.when.apply(null,dtdArry).done(function(){
		dtd.resolve();
	});
	return dtd;
	//console.log('trigger ' + eventName + " in " + this.id);
	//console.log('handlers.count= ' + handlers.length );
};

/**
 * attach the event handle function, component obj will be as "this" when call the event handler function
 * */
Component.prototype.on = function( eventName, f){
	var handlers = this.events[eventName] || [];
	handlers.push(f);
	this.events[eventName] = handlers;
	//console.log('on ' + eventName + " in " + this.id);
};

/**
 * binding data to component template to get html, and display the html in div which name is divId
 * */
Component.prototype.render = function( templateUrl, divId, data, callback){
	var self = this,
		//increase the count of divid, and will check this count when render html
		count = app.counts.increaseCount(divId),
		useUrl = typeof(data) === "string",
		dtd = $.Deferred();
	
		if( this.id == "initialMainContent" || this.id == "nonClientInitialMainContent" || divId == app.mainComponentDivId ) {
		if (app.mainComponent && !app.mainComponent.trigger("close")){
			return;
		}
	}
	if (divId == app.mainComponentDivId){
		if (this.id == "initialMainContent" || this.id == "nonClientInitialMainContent"){
			$("#bannerImage").removeClass();
			$("#bannerImage").addClass("banner");
//			$("div.bannerImg").css({"display":"none"});
//			$("#bannerContent").css({"height":"7px"});
		} else {
			$("#bannerImage").removeClass();
			$("#bannerImage").addClass("banner2");
			
//			$("div.bannerImg").css({"display":"block"});
//			$("#bannerContent").css({"height":"78px"});
		}
	}
	
	if(useUrl){
		this.showLoading(divId);		
	}
	$.when(ajaxCall({ url: app.EPWEB_CONTEXT_ROOT + templateUrl , dataType:"html"}, true), 
			useUrl? 
				ajaxCall({url: app.EPRESTAPI_CONTEXT_ROOT + data, dataType:'json'}, false)
				: data)
	.done( function(){
		/* disable now, because we use isLoading() to control it
		//if the difference link click frequently(ajax request is often),
		//only handle the last click
		if(count != app.counts.getCount(divId)){//app.mainContenCount) {
			dtd.reject(null, "discard", "discard");
			return;
		}*/
		
		//get page template, bind the data, then show in div
	    var template = (typeof(arguments[0]) === "string")?
	    		arguments[0] : arguments[0][0];
	    var returnData = useUrl? arguments[1][0] : arguments[1];
		
		
		var divObj = $("#" + divId);
		if (divObj.length > 0 && divObj[0].innerHTML){
			try{
				//a strange issue: when user add and save a FAQ question in IE7, empty() will cause IE be closed
				divObj[0].innerHTML = "";//"";
			}
			catch(e){
				//another strange issue: innerHTML = "" will let IE throw a runtime error when edit FAQ category, so should use $.empty()
				divObj.empty();	
			}
		}
		else{
			divObj.empty();	
		}
		
		var html = $.tmpl(template, returnData);
		html.appendTo("#" + divId);
		
		
		//setting mainComponent
		if(( self.id == "nonClientInitialMainContent"|| self.id == "initialMainContent" || self.id == "admin/managerLink" || self.id == "admin/managerFaqCate"  || divId == app.mainComponentDivId || self.id == "clientAccountList") && self.id != "announcement"){
			app.mainComponent = self;
		}
		var validator  = new Validator();
		validator.bindingEvent(divId);
		lang.updateUIMessages(divId);
//		encodeInputTextarea();
		if (callback){
			callback(template, returnData);
		}
		dtd.resolve(template, returnData);
	});
	return dtd;
};

/**
 * show a loading in divid
 * */
Component.prototype.showLoading = function(divId,isLogout){
    var getTop =  function(height){
        var height = Math.ceil(height/2 - 15);
        return height > 1 ? height: 1;
    };
    var div = $("#" + divId);
    var divWidth = div.width();
    
    //temp fix
    if(divId=='announcementContent'&& divWidth==0){
    	divWidth = 859;
    }
    if(divId=='estatement'&& divWidth==0){
    	divWidth = 180;
    }
    
    if(divId=='portfolioHLSumarryZone' && divWidth==0){
    	divWidth = 459;
    }
    else if(divId=='foreignExchangeTableZone' && divWidth==0){
    	divWidth = 314;
    }

    var left = (divWidth/2 - 15) + "px";
    var top;
    if(divId == "mainContent") {
        var windowHeight = $(window).height();
        top = (windowHeight/2 - 115);
    }
    else{
    	if(div.height()==0){
    		top = 10;
    	}
    	else{
    		top =  getTop(div.height());
    	}
    }
    if(divId == "clientAccountListZone"){
        top = 135;
    }
	
	var divHtml ="";
	if(isLogout===true){
		divHtml = "<div id='loadingDiv' style='width: 31px; position: relative; left:" + left + "; top:" + top + "px;z-index:10001;'><div class='loadingdiv'></div></div>";
	}else{
		divHtml = "<div id='loadingDiv' style='width: 31px; position: relative; left:" + left + "; top:" + top + "px'><div class='loadingdiv'></div></div>";
	}
		
	
	div.html(divHtml);
	
	var divArray = ["qucikLink","quickLinkAdmin2","estatementDownloadFileList"];
	
	divArray.forEach(function(vDivid){
	    if (vDivid == divId){
	        div.css({"min-height":"193px"});
	    }
	});
	
	/*
    var id = divId.indexOf(" ") > 0 ? divId.substring(0, divId.indexOf(" ")) : divId;
    var divHtml = "<div id='loadingDiv" + id + "' style='width: 31px; position: relative; left:" + left + "; top:" + top + "px'><div class='loadingdiv'></div></div>";
    
    div.html(divHtml);
    if(divId != "mainContent") {
        $("#loadingDiv" + id).css("top", getTop(div.height()) + "px");
    }
    */
		  
	
};
