var initialMainContent = new Component("initialMainContent");

app.registerComponent(initialMainContent);

initialMainContent.rolesMapping = {
		//client
		"hasAnyRole('WMD_Clients')" : [
		                             	"portfolioHLSummary","exchangeRates"
		                             ],
		//RM
		"hasAnyRole('WMD_Super','WMD_RMs','WMD_CSOs','WMD_BADTs','WMD_RTBs')" : [
		                                                 	"exchangeRates","portfolioHLSummary"
		                                                 ]
};

initialMainContent.on("load",function(){
     var self = this;
     app.mainComponent = this;
     
	 var displayDivId = app.mainComponentDivId;
	 return this.render("template/homepage.html", displayDivId, null).pipe(function(){
	     
		 app.user.role.checkHtmlElements();
	     var dtdList = [];
	     dtdList.push(app.trigger("call", "announcement","loadTop").done(function(){app.user.role.checkHtmlElements();}));
	     dtdList.push(app.user.role.checkComponents(self.rolesMapping));
	     
	     $("#HLSummarySelectAsofdate").val(app.selectDateValue);
	     
	     return $.when.apply(null,dtdList).done(function(){
	         
	     });
	     
	 });

});

$("#HLSummarySelectAsofdate").die().live("change", function(){
    trackAction("Summary - ChangeDate");
    app.trigger("changeAsOfDate", null, $("#HLSummarySelectAsofdate").val());
    app.trigger("load", "portfolioHLSummary");
    app.trigger("load", "exchangeRates");    	
});
