var announcement = new Component("announcement");
app.registerComponent(announcement);
announcement.cacheData = {};
announcement.cachPageNo = 1;
announcement.cacheAnnounceId = 0;
announcement.mode = "top";

var langFields = {
        "en":["announceTitleEN","announceContentEN","announceCatEN"],
        "zh_CN":["announceTitleSC","announceContentSC","announceCatSC"],
        "zh_TW":["announceTitleTC","announceContentTC","announceCatTC"]
};

announcement.on( "load", function(){    
    if (announcement.mode == "top"){
        return announcement.loadTopData();
    }else if (announcement.mode == "list"){
        return announcement.list(announcement.cachPageNo);
    }else if (announcement.mode == "detail"){
    	return announcement.view(announcement.cacheAnnounceId);
    }
});

announcement.readList = function( divid, request, template, callback){
    var currentI18N= lang.currentLang;
    app.doAjaxRequest = true;
    return ajaxCall(request).done(function(returnData){
        var renderData = {};
        renderData.meta = returnData.meta;
        renderData.pagination = returnData.pagination;
        renderData.data = {};        
       
        renderData.data.data = [];
        for (var i = 0 ; i < returnData.data.data.length ; i++){
             var sourceObj = returnData.data.data[i];
             var announceObj = announcement.copyData(sourceObj,currentI18N);
             announceObj.lang = lang.currentLang;
             renderData.data.data.push(announceObj);
        }        
        announcement.render(
             template, 
             divid, 
             renderData
        ).done( function(template,data){
            if (callback){
                callback(template, returnData);
            }
            app.doAjaxRequest = false;
        });
    }); 
};

announcement.on( "loadTop", function(){
	return announcement.loadTopData();
});

announcement.on( "loadList", function(){
	return announcement.list(1);
});

/**
 * load top 4 template with data.
 */
announcement.loadTopData = function(){
    trackAction("Announcement - ShortList");
    announcement.showLoading("announcementContent");
    announcement.mode = "top";
    var currentI18N= lang.currentLang;
    var template = "template/announce_top.html";
    var requestUrl = app.EPRESTAPI_CONTEXT_ROOT + "announcement/page/" + announcement.cachPageNo +"?pageSize=" + app.ANNOUNCEMENT_TOPNUM + "&type=client&language=" + currentI18N;
   
    var request = {url : requestUrl, data : {}, type : "GET" , async : true};
    return announcement.readList("announcementContent",request,template,null);
    
};


/**
 * pagination call back.
 */
announcement.listCallBack = function(template, data){
    var html = genPaginationFooter(data.pagination, "announcement.list");
    $("#announcementPaginationBottom").empty().append(html);
    $("#announcementPaginationTop").empty().append(html);
};

/**
 * pagination list all announcement.
 */
announcement.list = function(currentPage){
    trackAction("Announcement - List");
    trackAction("Announcement - ChangePage");
    $("#mainContent").empty();
    announcement.showLoading("mainContent");
    announcement.mode = "list";
    announcement.cachPageNo = currentPage;
    var currentI18N= lang.currentLang;
    var requestUrl = app.EPRESTAPI_CONTEXT_ROOT + "announcement/page/" + announcement.cachPageNo +"?pageSize=" + app.ANNOUNCEMENT_PAGESIZE + "&type=client&language=" + currentI18N;
    var request = {url : requestUrl, data : {}, type : "GET" };
    var template = "template/announce_list.html";    
    return announcement.readList("mainContent",request,template,announcement.listCallBack);
};

/**
 * @param id
 * according announcement id , get content of announcement.
 */
announcement.view = function(id){
    trackAction("Announcement - View");
    $("#mainContent").empty();
    announcement.showLoading("mainContent");
    announcement.cacheAnnounceId = id;
    var currentI18N= lang.currentLang;
    var template = "template/announce_detail.html";
    var requestUrl = app.EPRESTAPI_CONTEXT_ROOT + "announcement/" + id + "/?language=" + currentI18N;
    announcement.mode = "detail";
    var request = {url : requestUrl, data : {}, type : "GET" };
    return ajaxCall(request).pipe(function(returnData){
        var renderData = {};
        renderData.meta = returnData.meta;
        renderData.pagination = returnData.pagination;
        renderData.data = {};        
        var sourceObj = returnData.data.data;
        renderData.data.data = {};
        var announceObj = announcement.copyData(sourceObj,currentI18N);
        renderData.data.data = announceObj;
        if ( $.trim( announceObj.announceTitle ) == '' ){
            return announcement.list(1);
        }
        else{
            return announcement.render(
                template, 
                "mainContent", 
                renderData
        ).done( function(template,data){
            
          });
        }
    });
    
};

/**
 * download attachment of announcement
 */
announcement.downloadAttachment = function(id){
    trackAction("Announcement - Download");
	var cnumber = getCookie("cnumber");
    var downloadUrl = app.EPRESTAPI_CONTEXT_ROOT +'announcement/attachment/' + id+"?cnumber="+cnumber;
    window.location = downloadUrl;
};

/**
 * copy data from source announcement object.
 */
announcement.copyData = function(sourceObj,currentLang){
    var announceObj = {};
    announceObj.announceId = sourceObj.announceId;
    announceObj.announceTitle = sourceObj[ langFields[currentLang][0] ];
    announceObj.announceContent = sourceObj[ langFields[currentLang][1] ];
    announceObj.announceCat = sourceObj[ langFields[currentLang][2] ];
    announceObj.createdDate = sourceObj.createdDate;
    announceObj.createdDateStr = sourceObj.createdDateStr;
    announceObj.attachCount = sourceObj.attachCount;
    announceObj.attachments = [];
    for(var j = 0 ; j<sourceObj.attachments.length ; j++){
        if (sourceObj.attachments[j].announceLang == currentLang){
            announceObj.attachments.push(sourceObj.attachments[j]);
        }
    }
    return announceObj;
};



