var managerAuditTrail = new Component("admin/managerAuditTrail");
app.registerComponent(managerAuditTrail);

/**
 * init page data, year and month and week and days.
 * dynamic assign "action" property to form .
 */
managerAuditTrail.init = function(){
    managerAuditTrail.buttonEvent();
    var date = new Date();
    var currentYear = date.getFullYear();
    var currentMonth = date.getMonth() + 1;
    //var currentDate = date.getDate();
    fillinAllMonthOptions(
            ["loginMonth_1","loginMonth_2","auditMonth_1","auditMonth_2"],
            currentMonth
    );
    fillinAllYearOptions(["loginYear","auditYear"],currentYear); 
    fiilinDays(currentYear,currentMonth,["auditDay","loginDay"]);
    fillinWeeks(currentYear,["auditWeeks","loginWeeks"]);
    
//    $("#download_audit_form").get(0).action = app.EPRESTAPI_CONTEXT_ROOT + "audit/download?cnumber=" + getCookie("cnumber");
//    $("#download_login_form").get(0).action = app.EPRESTAPI_CONTEXT_ROOT + "audit/download?cnumber=" + getCookie("cnumber");
};

/**
 * render the main area.
 */
managerAuditTrail.on( "load", function(){
    this.showLoading("mainContent"); 
    return managerAuditTrail.render(
            "template/admin/managerAuditLog.html",
            "mainContent",
            {}
   ).done( function(){
       managerAuditTrail.init();
   });            
         
});

/**
 * init the event of the button,
 * include select change and download button click.
 */
managerAuditTrail.buttonEvent = function () { 
    
    $("#loginYear").die();
    $("#loginYear").live("change", function(){       
        var year = $(this).val();       
        fillinWeeks(year,["loginWeeks"]); 
        $("#loginMonth_2").change();
    });
    
    $("#auditYear").die();
    $("#auditYear").live("change", function(){       
        var year = $(this).val();       
        fillinWeeks(year,["auditWeeks"]); 
        $("#auditMonth_2").change();
    });   
    
    
    $("#loginMonth_2").die();
    $("#loginMonth_2").live("change", function(){
        var year = $("#loginYear").val();
        var month = $(this).val();
        var daysOfMonth = getMonthDays(year,month);
        fillinDay("loginDay",daysOfMonth);
    });
    
    $("#auditMonth_2").die();
    $("#auditMonth_2").live("change", function(){
        var year = $("#auditYear").val();
        var month = $(this).val();
        var daysOfMonth = getMonthDays(year,month);
        fillinDay("auditDay",daysOfMonth);
    });
    
    $("#audit_download").die();
    $("#audit_download").live("click", function(){        
        var requestUrl = app.EPRESTAPI_CONTEXT_ROOT + "audit/download?cnumber=" + getCookie("cnumber")+"&" + $("#download_audit_form").serialize();
        window.location = requestUrl;
          
    });
    
    $("#login_download").die();
    $("#login_download").live("click", function(){
        var requestUrl = app.EPRESTAPI_CONTEXT_ROOT + "audit/download?cnumber=" + getCookie("cnumber")+"&" + $("#download_login_form").serialize();
        window.location = requestUrl;
    });
    
    
      
};

