package com.nomura.chart;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class BarTest {

    public static void main(final String[] args) throws IOException { 
        long start = System.currentTimeMillis();
        genBar(); 
        genStackedBar();
        long end = System.currentTimeMillis();
        System.out.println(end-start);
    }
    
    public static void genStackedBar() throws IOException{
        
        Map<String,Color> colorMap = new HashMap<String,Color>();        
        List<String> cats = new ArrayList<String>();
        cats.add("Bonds");
        cats.add("Equity");
        cats.add("Cash");
      
        
        List<String> currencies = new ArrayList<String>();
        currencies.add("USD");
        currencies.add("JPY");
       /* currencies.add("HKD");
        currencies.add("SGD");
        currencies.add("EUR");
        currencies.add("AUD");*/
        currencies.add("OTHER");
        
        Map<String,Map<String,Double>> dataMap = new LinkedHashMap<String,Map<String,Double>>();
        Random random = new Random();
        for(String cat:cats){
            Map<String,Double> valueMap= new LinkedHashMap<String,Double>();
            for(String currency:currencies){
                valueMap.put(currency, random.nextDouble()*1000);               
               
            }
            dataMap.put(cat, valueMap);
        }
        
        colorMap.put("USD", new Color(41,77,132));
        colorMap.put("JPY", new Color(0,97,156)); 
        colorMap.put("HKD", new Color(140,158,198));
        colorMap.put("SGD", new Color(115,170,214));
        colorMap.put("EUR", new Color(222,223,231)); 
        colorMap.put("AUD", new Color(189,190,198)); 
        colorMap.put("OTHER", new Color(140,146,156)); 
        
        System.out.println(Bar.generateStackedBar(dataMap, colorMap, "d:\\", 606, 200, 0D , 0D) );
    }
   
    public static void genBar() throws IOException{
        Map<String,Double> dataMap = new LinkedHashMap<String,Double>();
        dataMap.put("USD", 100000D);
        dataMap.put("SGD", 50000D);
        dataMap.put("OTHER", 30000D);
        dataMap.put("JPY", 1000D);
        dataMap.put("HKD", 0D);
        dataMap.put("EUR", 0D);
        dataMap.put("AUD", 0D);        
        System.out.println( Bar.generateBar(dataMap, new Color(0,97,156), "d:", 606, 250, 120000D, 20000D) );
    }
    
   
}
