package com.nomura.chart.util;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;

public class ExtendedChartFactory extends ChartFactory {
    
    private static ChartTheme currentTheme = new StandardChartTheme("JFree");
    
    public static JFreeChart createPieChart(String title,
            PieDataset dataset,
            boolean legend,
            boolean tooltips,
            boolean urls) {

            ExtendedPiePlot plot = new ExtendedPiePlot(dataset);
            plot.setLabelGenerator(new StandardPieSectionLabelGenerator());
            plot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
            if (tooltips) {
            plot.setToolTipGenerator(new StandardPieToolTipGenerator());
            }
            if (urls) {
            plot.setURLGenerator(new StandardPieURLGenerator());
            }
            JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT,  plot, legend);
            currentTheme.apply(chart);
            return chart;
}


}
