package com.nomura.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;

import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PieLabelLinkStyle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.ui.RectangleInsets;

import com.nomura.chart.util.ExtendedChartFactory;
import com.nomura.chart.util.ExtendedPiePlot;



public class Pie { 
    
    public static String generatePieImage(Map<String,Double> dataMap,
                                          Map<String,Color> colorMap,
                                          String path,int imageWidth,int imageHeight){
        if ( dataMap.size() != colorMap.size() ){
            throw new RuntimeException("The length of dataMap does not equal the length of colorMap");
        }
        
        try{
            DefaultPieDataset dataSet = new DefaultPieDataset();
            for (Map.Entry<String, Double> entry : dataMap.entrySet()) {
                dataSet.setValue(entry.getKey(), entry.getValue());
            }
            
            JFreeChart pieChart=ExtendedChartFactory.createPieChart("",dataSet,false,false,false); 
            pieChart.setBorderVisible(false);
          
            
            RectangleInsets padding = new RectangleInsets();
            padding.calculateLeftInset(0d);
            pieChart.setPadding(padding );
            
            ExtendedPiePlot plot = (ExtendedPiePlot) pieChart.getPlot();
            plot.setCircular(true);  
            //plot.setStartAngle(30D);
            
           
           
            plot.setLabelLinkStyle(PieLabelLinkStyle.STANDARD);
           
            plot.setLabelBackgroundPaint(Color.WHITE);
            plot.setLabelFont(new Font("SansSerif", Font.PLAIN, 10));
            plot.setLabelShadowPaint(Color.WHITE);
            plot.setLabelOutlinePaint(Color.WHITE);
            plot.setLabelGenerator(new StandardPieSectionLabelGenerator(  
                    "{0} ({2})", NumberFormat.getNumberInstance(),  
                    new DecimalFormat("0.00%")));             
           
            
            plot.setShadowPaint(Color.WHITE);
            plot.setBackgroundPaint(Color.WHITE);
            plot.setOutlinePaint(Color.WHITE);
            
            Stroke splitLine = new BasicStroke(1.0f);
            plot.setSectionOutlineStroke(splitLine);
            plot.setSectionOutlinePaint(Color.WHITE);  
            
      
           
            
            for (Map.Entry<String, Color> entry : colorMap.entrySet()) {
                plot.setSectionPaint(entry.getKey(), entry.getValue());
            }
            
            long timeStamp = System.currentTimeMillis();
            String filePath = path;
            if ( !path.endsWith(File.separator) ){
                filePath = path + File.separator;
            }
            File pieChartFile = new File(filePath + timeStamp + ".png");              
            ChartUtilities.saveChartAsPNG(pieChartFile,pieChart,imageWidth,imageHeight);
            return filePath + timeStamp + ".png" ; 
            
        }catch(Exception e){
            e.printStackTrace();
            return null;
        } 
    }      
}