package com.nomura.chart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.util.Map;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.VerticalAlignment;

import com.nomura.chart.util.ExtendedStackedBarRenderer;

public class Bar {
    
    private static String processChart(boolean isStacked,JFreeChart chart, Color color,
                                        Map<String,Color> colorMap,
                                        String path,
                                        int imageWidth,
                                        int imageHeight,
                                        Double upperRange,
                                        Double rangeGap){
        try{
            LegendTitle legend = chart.getLegend();
            if (!isStacked){
                legend.setVisible(false);
            }
            else{               
                BlockContainer blockContainer = new BlockContainer(new BorderArrangement());
                blockContainer.setBorder(BlockBorder.NONE);
                LabelBlock currencyLabel = new LabelBlock("Currency");
                currencyLabel.setPadding(5D, 0D, 5D, 5D);
                blockContainer.add(currencyLabel, RectangleEdge.TOP);
                
                BlockContainer legendBlockContainer = legend.getItemContainer();
                blockContainer.add(legendBlockContainer);
                legend.setWrapper(blockContainer);
                //legend.setMargin(2D, 0, 0, 0);
                legend.setPosition(RectangleEdge.RIGHT);
                legend.setVerticalAlignment(VerticalAlignment.TOP);
                legend.setBackgroundPaint(Color.WHITE);
                BlockBorder border = new BlockBorder();
                legend.setBorder(BlockBorder.NONE );
            }
    
            chart.setBackgroundPaint(Color.WHITE);
            CategoryPlot plot = chart.getCategoryPlot();       
             
            ExtendedStackedBarRenderer barRender = new ExtendedStackedBarRenderer();
            barRender.setBaseItemLabelsVisible(false);
            barRender.setBaseItemLabelGenerator(new StandardCategoryItemLabelGenerator());
            barRender.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
            barRender.setDrawBarOutline(true); 
            plot.setRenderer(barRender);
            NumberAxis localNumberAxis = (NumberAxis)plot.getRangeAxis();
            localNumberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            
            ValueAxis range = plot.getRangeAxis();
            range.setAxisLineVisible(false);
            range.setTickMarksVisible(false);
            if ( upperRange > 0D ){
                range.setUpperBound(upperRange);
            }
            if ( rangeGap > 0D ){
                range.setAutoRangeMinimumSize(rangeGap);
            }
            
            CategoryAxis domain = plot.getDomainAxis();
            domain.setAxisLineVisible(false);
            
            ChartUtilities.applyCurrentTheme(chart);
           
            plot.setBackgroundPaint(Color.WHITE);
            plot.setOutlinePaint(Color.WHITE);
            plot.setRangeGridlinePaint(Color.BLACK);
            
            Stroke line = new BasicStroke(0.5f);
            plot.setRangeGridlineStroke(line);
            
            int seriesIndex = 0;
            if (isStacked){
                for (Map.Entry<String, Color> entry : colorMap.entrySet()) {
                    barRender.setSeriesPaint(seriesIndex, entry.getValue()); 
                    barRender.setSeriesOutlinePaint(seriesIndex, Color.WHITE);
                    seriesIndex++;
                }
            }
            else{
                barRender.setSeriesPaint(0, color);     
            }
                   
            long timeStamp = System.currentTimeMillis();
            String filePath = path;
            if ( !path.endsWith(File.separator) ){
                filePath = path + File.separator;
            }
            File pieChartFile = new File(filePath + timeStamp + ".png");
            ChartUtilities.saveChartAsPNG(pieChartFile,chart,imageWidth,imageHeight);        
            return filePath + timeStamp + ".png";
        }catch(Exception e){
            e.printStackTrace();
            return "";
        }
        
    }
    
    public static String generateBar( Map<String,Double> dataMap,
                                    Color color,
                                    String path,
                                    int imageWidth,
                                    int imageHeight,
                                    Double upperRange,
                                    Double rangeGap) throws IOException{
        
        DefaultCategoryDataset dataSet = new DefaultCategoryDataset();
        for (Map.Entry<String,Double> entry : dataMap.entrySet()) {
            dataSet.addValue(entry.getValue(), "", entry.getKey());
        }  
        JFreeChart chart = ChartFactory.createBarChart("", "", "", dataSet, PlotOrientation.VERTICAL, true, false, false);
        return processChart(false, chart, color, null, path, imageWidth, imageHeight, upperRange, rangeGap);
        
    }
    
    public static String generateStackedBar(Map<String,Map<String,Double>> dataMap,                                          
                                          Map<String,Color> colorMap,
                                          String path,
                                          int imageWidth,
                                          int imageHeight,
                                          Double upperRange,
                                          Double rangeGap) throws IOException{ 
        
        DefaultCategoryDataset dataSet = new DefaultCategoryDataset();        
        
        for (Map.Entry<String, Map<String,Double>> entry : dataMap.entrySet()) {
            Map<String,Double> currencyValueMap = entry.getValue();
            for (Map.Entry<String, Double> subEntry : currencyValueMap.entrySet()) {
                dataSet.setValue(subEntry.getValue(), subEntry.getKey(), entry.getKey());
            }            
        }        
        
        JFreeChart chart = ChartFactory.createStackedBarChart("", "", "", dataSet, PlotOrientation.VERTICAL, true, false, false);
        return processChart(true, chart, null, colorMap, path, imageWidth, imageHeight, upperRange, rangeGap);      
    }    

}
