package com.memorynotfound.validator;

import com.memorynotfound.model.FileBucket;
import com.memorynotfound.model.MultiFileBucket;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class MultipleFileValidator implements Validator {

    @Override
    public boolean supports(Class<?> clazz) {
        return MultiFileBucket.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(Object target, Errors errors) {
        MultiFileBucket multiBucket = (MultiFileBucket) target;

        int index = 0;
        for (FileBucket bucket : multiBucket.getFiles()){
            if (bucket.getFile() != null && bucket.getFile().isEmpty()){
                errors.rejectValue("files[" + index + "].file", "file.empty");
            }
            index++;
        }
    }
}
