package com.memorynotfound.controller;

import com.memorynotfound.model.FileBucket;
import com.memorynotfound.model.MultiFileBucket;
import com.memorynotfound.validator.MultipleFileValidator;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import javax.validation.Valid;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

@Controller
@RequestMapping("/multiple")
public class MultiFileUploadController {

    @Autowired
    private MultipleFileValidator multipleFileValidator;

    @ModelAttribute
    public MultiFileBucket multiFileBucket(){
        return new MultiFileBucket(3);
    }

    @InitBinder
    protected void initBinderFileBucket(WebDataBinder binder) {
        binder.setValidator(multipleFileValidator);
    }

    @RequestMapping(method = RequestMethod.GET)
    public String multiple(){
        return "multiple";
    }

    @RequestMapping(method = RequestMethod.POST)
    public String handleFormUpload(@Valid MultiFileBucket buckets,
                                   BindingResult result,
                                   RedirectAttributes redirectMap) throws IOException {

        if (result.hasErrors()){
            return "multiple";
        }

        String[] files = new String[buckets.getFiles().size()];
        int index = 0;
        for (FileBucket bucket : buckets.getFiles()){
            MultipartFile file = bucket.getFile();
            InputStream in = file.getInputStream();
            File destination = new File("/tmp/" + file.getOriginalFilename());
            FileUtils.copyInputStreamToFile(in, destination);

            files[index] = file.getOriginalFilename();
            index++;
        }

        redirectMap.addFlashAttribute("filenames", files);

        return "redirect:success";
    }

}
